%%% NYUSIM - User License %%%

% Copyright (c) 2017 New York University and NYU WIRELESS

% Permission is hereby granted, free of charge, to any person obtaining a 
% copy of this software and associated documentation files (the Software),
% to deal in the Software without restriction, including without limitation 
% the rights to use, copy, modify, merge, publish, distribute, sublicense, 
% and/or sell copies of the Software, and to permit persons to whom the 
% Software is furnished to do so, subject to the following conditions:

% The above copyright notice and this permission notice shall be included
% in all copies or substantial portions of the Software. Users shall cite 
% NYU WIRELESS publications regarding this work.

% THE SOFTWARE IS PROVIDED AS IS, WITHOUTWARRANTY OF ANY KIND, EXPRESS OR 
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
% THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
% OTHER LIABILITY, WHETHER INANACTION OF CONTRACT TORT OR OTHERWISE, 
% ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
% OTHER DEALINGS IN THE SOFTWARE.

function [hLeg,hGca,h] = plotSpherical_Modular(power_azi_el_true,titleName,envType,FigVisibility)        
        
    %%% minimum/maximum received power in the spherical spectrum
    minPower = getMinPower(power_azi_el_true);
    maxPower = max(max(power_azi_el_true(:,1,:)));

    %%% manipulate the power_azi_el_true matrix for plotting
    power_azi_el_plot = prepareForPlotting(power_azi_el_true,minPower);

    %%% open figure
    figure('visible',FigVisibility);
    hold on
    grid on
    box on

    %%% define title of graph
    title(titleName,'fontsize',18,'fontweight','bold')

    %%% set all text to bold
    set(gca,'fontweight','bold')

    %%% remove ticklabels from plot
    set(gca,'XTickLabel',[])
    set(gca,'YTickLabel',[])
    set(gca,'ZTickLabel',[])

    %%% all axes equal for viewing purposes
    axis equal        

    %%% Step 1: Plot 3 spherical colored surfaces
    if strcmp(envType,'LOS')== true
        margin = 15;
    elseif strcmp(envType,'NLOS')== true
        margin = 20;
    else
    end
    [smallestPower middlePower largestPower] = ...
        plotSpheres(maxPower,minPower,margin);

    %%% Step 2: Plot (azi,el,power) angular segments
    plotSphericalSegments(power_azi_el_plot)

    %%% Spte 3: Plot connecting lines between angular segments for a given
    %%% azimuth angle cut
%     plotConnectingLine(power_azi_el_plot)   
    
    %%% plot legend
    hLeg = legend([num2str(smallestPower,'%.0f'),' dBm'],[num2str(middlePower,'%.0f'),' dBm'],...
        [num2str(largestPower,'%.0f'),' dBm']);
    
    %%% set legend font size
    set(hLeg,'fontsize',16,'position',[0.6913    0.2337    0.1946    0.1444])
    
    %%% get gca for this figure
    hGca = gca;
    
    set(gca,'view',[-119 0])

    set(gcf,'color','w');
    set(gcf,'Unit','Inches');
    pos = get(gcf,'Position');
    set(gcf','PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3) pos(4)]);

h = gcf;
end